import os
import os.path
import urllib2
import time

def getpages(dest):
    url_template = 'https://digital.library.temple.edu/digital/api/singleitem/image/p15037coll14/%s/default.jpg'
    for pagenum in range(1362, 1748):
        path = os.path.join(dest, '%s.jpg' % pagenum)
        if os.path.exists(path):
            continue
        url = url_template % pagenum
        print('getting %s' % url)
        img = urllib2.urlopen(url)
        with open(path, 'w') as f:
            f.write(img.read())
        print('wrote %s' % path)
        time.sleep(1)

if __name__ == '__main__':
    dest = os.path.expanduser('~/projects/9generations/pages')
    if not os.path.isdir(dest):
        os.makedirs(dest)
    getpages(dest)
